<?php
// Untuk debugging, tampilkan semua error PHP.
// JANGAN PAKAI INI DI PRODUKSI! Ganti dengan error_log() atau matikan.
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// --- Header CORS (Cross-Origin Resource Sharing) ---
// Ini penting jika frontend dan backend Anda berada di domain/port yang berbeda.
// 'Access-Control-Allow-Origin: *' mengizinkan akses dari domain mana pun.
// DI LINGKUNGAN PRODUKSI, GANTI '*' dengan domain spesifik frontend Anda (misalnya: https://sumberbarokahsentosa.my.id)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS"); // Metode HTTP yang diizinkan
header("Access-Control-Allow-Headers: Content-Type, Authorization"); // Header yang diizinkan dalam request

// Jika metode request adalah OPTIONS (preflight request untuk CORS), kirim header 200 OK dan keluar
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Set header Content-Type ke application/json untuk semua respons
header('Content-Type: application/json');

// --- Sertakan file koneksi database Anda ---
include "koneksi.php"; // Pastikan path ini benar!

// Array untuk menyimpan respons API default
$response = ['status' => 'error', 'message' => 'Permintaan tidak valid atau aksi tidak ditemukan.'];

// --- Mendapatkan Aksi dari Request ---
// Aksi bisa datang dari parameter GET (untuk get_users, get_user_by_id)
// atau dari parameter POST (untuk add_user, edit_user, delete_user)
$action = $_GET['action'] ?? $_POST['action'] ?? '';

// --- Logika Penanganan Aksi ---
switch ($action) {

    // --- Aksi: Mengambil daftar semua pengguna ---
    case 'get_users':
        $sql = "SELECT id, username, role FROM user ORDER BY id ASC";
        $result = mysqli_query($conn, $sql);

        if ($result) {
            $users = [];
            while ($row = mysqli_fetch_assoc($result)) {
                $users[] = $row;
            }
            $response = ['status' => 'success', 'data' => $users];
        } else {
            // Kesalahan database saat mengambil data
            $response = ['status' => 'error', 'message' => 'Gagal mengambil data pengguna: ' . mysqli_error($conn)];
            http_response_code(500); // Internal Server Error
        }
        break;

    // --- Aksi: Mengambil detail satu pengguna berdasarkan ID ---
    case 'get_user_by_id':
        $id = isset($_GET['id']) ? (int)$_GET['id'] : 0; // Pastikan ID adalah integer

        if ($id <= 0) {
            $response = ['status' => 'error', 'message' => 'ID pengguna tidak valid.'];
            http_response_code(400); // Bad Request
            break;
        }

        $sql = "SELECT id, username, role FROM user WHERE id = $id LIMIT 1";
        $result = mysqli_query($conn, $sql);

        if ($result && mysqli_num_rows($result) > 0) {
            $user = mysqli_fetch_assoc($result);
            $response = ['status' => 'success', 'data' => $user];
        } else {
            $response = ['status' => 'error', 'message' => 'Pengguna tidak ditemukan.'];
            http_response_code(404); // Not Found
        }
        break;

    // --- Aksi: Menambah pengguna baru ---
    case 'add_user':
        // Pastikan request menggunakan metode POST
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            $response = ['status' => 'error', 'message' => 'Metode request tidak diizinkan untuk aksi ini.'];
            http_response_code(405); // Method Not Allowed
            break;
        }

        // Ambil data dari $_POST karena formulir frontend mengirim FormData
        $username = $_POST['username'] ?? '';
        $password = $_POST['password'] ?? '';
        // Default role jika tidak diberikan. Pastikan ini adalah salah satu dari 'admin', 'karyawan', 'pelanggan'
        $role = $_POST['role'] ?? 'karyawan'; 

        // Validasi input dasar
        if (empty($username) || empty($password)) {
            $response = ['status' => 'error', 'message' => 'Username dan password wajib diisi.'];
            http_response_code(400); // Bad Request
            break;
        }

        // Daftar role yang diizinkan. PASTIKAN INI SAMA DENGAN OPSI DI FRONTEND & ENUM DI DATABASE
        $allowed_roles = ['admin', 'karyawan', 'pelanggan'];
        if (!in_array($role, $allowed_roles)) {
            $response = ['status' => 'error', 'message' => 'Role tidak valid. Pilihan role: admin, karyawan, pelanggan.'];
            http_response_code(400); // Bad Request
            break;
        }

        // Sanitasi input untuk mencegah SQL Injection
        $username = mysqli_real_escape_string($conn, $username);
        $role = mysqli_real_escape_string($conn, $role);

        // Cek apakah username sudah ada di database
        $sql_check = "SELECT id FROM user WHERE username = '$username' LIMIT 1";
        $result_check = mysqli_query($conn, $sql_check);

        if (!$result_check) {
            // Kesalahan kueri SQL saat memeriksa username
            $response = ['status' => 'error', 'message' => 'Terjadi kesalahan server saat memeriksa username: ' . mysqli_error($conn)];
            http_response_code(500); // Internal Server Error
        } else if (mysqli_num_rows($result_check) > 0) {
            // Username sudah ada
            $response = ['status' => 'error', 'message' => 'Username sudah digunakan.'];
            http_response_code(409); // Conflict
        } else {
            // Hash password sebelum menyimpan ke database
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);

            // Simpan data pengguna baru ke database
            $sql_insert = "INSERT INTO user (username, password, role) VALUES ('$username', '$hashed_password', '$role')";

            if (mysqli_query($conn, $sql_insert)) {
                $new_user_id = mysqli_insert_id($conn); // Dapatkan ID pengguna yang baru saja dibuat
                $response = [
                    "status" => "success",
                    "message" => "Pengguna berhasil ditambahkan!",
                    "data" => [
                        "user_id" => $new_user_id,
                        "username" => $username,
                        "role" => $role
                    ]
                ];
                http_response_code(201); // 201 Created: Berhasil membuat resource baru
            } else {
                // Kesalahan database saat insert
                $response = ['status' => 'error', 'message' => 'Gagal menambahkan pengguna: ' . mysqli_error($conn)];
                http_response_code(500); // Internal Server Error
            }
        }
        break;

    // --- Aksi: Mengedit pengguna yang sudah ada ---
    case 'edit_user':
        // Pastikan request menggunakan metode POST
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            $response = ['status' => 'error', 'message' => 'Metode request tidak diizinkan untuk aksi ini.'];
            http_response_code(405);
            break;
        }

        $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
        $username = $_POST['username'] ?? '';
        $role = $_POST['role'] ?? '';
        $new_password = $_POST['password'] ?? ''; // Opsional: jika kosong, password tidak diubah

        // Validasi input yang diperlukan untuk edit
        if ($id <= 0 || empty($username) || empty($role)) {
            $response = ['status' => 'error', 'message' => 'ID, username, dan role wajib diisi untuk edit.'];
            http_response_code(400); // Bad Request
            break;
        }

        // Daftar role yang diizinkan
        $allowed_roles = ['admin', 'karyawan', 'pelanggan'];
        if (!in_array($role, $allowed_roles)) {
            $response = ['status' => 'error', 'message' => 'Role tidak valid. Pilihan role: admin, karyawan, pelanggan.'];
            http_response_code(400); // Bad Request
            break;
        }

        // Sanitasi input
        $username = mysqli_real_escape_string($conn, $username);
        $role = mysqli_real_escape_string($conn, $role);

        // Buat bagian UPDATE query secara dinamis
        $update_parts = ["username = '$username'", "role = '$role'"];
        if (!empty($new_password)) {
            // Hanya hash dan tambahkan password jika ada password baru diberikan
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            $update_parts[] = "password = '$hashed_password'";
        }

        $sql_update = "UPDATE user SET " . implode(", ", $update_parts) . " WHERE id = $id";

        if (mysqli_query($conn, $sql_update)) {
            // Periksa apakah ada baris yang benar-benar terpengaruh (berubah)
            if (mysqli_affected_rows($conn) > 0) {
                $response = ["status" => "success", "message" => "Pengguna berhasil diperbarui!"];
            } else {
                // Jika tidak ada baris yang terpengaruh, mungkin ID tidak ditemukan atau data yang dikirim sama
                $response = ["status" => "info", "message" => "Pengguna ditemukan tetapi tidak ada perubahan data atau ID tidak ditemukan."];
            }
        } else {
            // Kesalahan database saat update
            $response = ['status' => 'error', 'message' => 'Gagal memperbarui pengguna: ' . mysqli_error($conn)];
            http_response_code(500); // Internal Server Error
        }
        break;

    // --- Aksi: Menghapus pengguna ---
    case 'delete_user':
        // Pastikan request menggunakan metode POST
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            $response = ['status' => 'error', 'message' => 'Metode request tidak diizinkan untuk aksi ini.'];
            http_response_code(405);
            break;
        }

        $id = isset($_POST['id']) ? (int)$_POST['id'] : 0; // Ambil ID dari POST dan pastikan integer

        if ($id <= 0) {
            $response = ['status' => 'error', 'message' => 'ID pengguna tidak valid.'];
            http_response_code(400); // Bad Request
            break;
        }

        $sql_delete = "DELETE FROM user WHERE id = $id";

        if (mysqli_query($conn, $sql_delete)) {
            // Periksa apakah ada baris yang benar-benar dihapus
            if (mysqli_affected_rows($conn) > 0) {
                $response = ["status" => "success", "message" => "Pengguna berhasil dihapus!"];
            } else {
                // Jika tidak ada baris yang terpengaruh, berarti ID tidak ditemukan
                $response = ["status" => "info", "message" => "Pengguna tidak ditemukan."];
                http_response_code(404); // Not Found
            }
        } else {
            // Kesalahan database saat delete
            $response = ['status' => 'error', 'message' => 'Gagal menghapus pengguna: ' . mysqli_error($conn)];
            http_response_code(500); // Internal Server Error
        }
        break;

    // --- Aksi default jika tidak ada aksi yang valid atau aksi tidak dikenal ---
    default:
        $response = ['status' => 'error', 'message' => 'Aksi tidak dikenal atau tidak diberikan.'];
        http_response_code(400); // Bad Request
        break;
}

// --- Mengirim Respons JSON ke Klien ---
echo json_encode($response);

// --- Tutup koneksi database ---
mysqli_close($conn);

// Menghentikan eksekusi script untuk memastikan tidak ada output lain setelah JSON
exit();
?>