<?php
// Enable error logging (disable display in production)
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/error.log');

// Mulai sesi jika belum dimulai
// PENTING: session_start() harus dipanggil sebelum output HTML atau header lainnya
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Set headers for API
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS'); // Hanya izinkan POST untuk membuat transaksi
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

// Handle CORS preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Database connection
$host = 'localhost';
$user = 'rhlqyjgg_admin';
$pass = 'xub!.&%O1pOU';
$db   = 'rhlqyjgg_dbbengkel';

$conn = new mysqli($host, $user, $pass, $db);
$conn->set_charset('utf8mb4');
if ($conn->connect_error) {
    http_response_code(500);
    error_log('Database connection failed: ' . $conn->connect_error);
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
    exit;
}

function respond($status, $message, $extra = []) {
    echo json_encode(array_merge(['status' => $status, 'message' => $message], $extra));
    exit;
}

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    $sparepart_id = intval($input['sparepart_id'] ?? 0);
    $jenis = $conn->real_escape_string($input['jenis'] ?? ''); // 'masuk' atau 'keluar'
    $jumlah = intval($input['jumlah'] ?? 0);
    $ppn = floatval($input['ppn'] ?? 0.0);
    $keterangan = $conn->real_escape_string($input['keterangan'] ?? null);

    // Ambil nama karyawan dari sesi
    $loggedInEmployeeName = isset($_SESSION['username']) ? $conn->real_escape_string($_SESSION['username']) : 'Unknown Employee';

    // Validasi input
    if ($sparepart_id <= 0) {
        respond('error', 'ID sparepart tidak valid.');
    }
    if (!in_array($jenis, ['masuk', 'keluar'])) {
        respond('error', 'Jenis transaksi tidak valid. Harus "masuk" atau "keluar".');
    }
    if ($jumlah <= 0) {
        respond('error', 'Jumlah harus lebih dari 0.');
    }
    // PPN bisa 0, tapi tidak boleh negatif
    if ($ppn < 0) {
        respond('error', 'PPN tidak boleh negatif.');
    }

    // Mulai transaksi database untuk memastikan konsistensi data
    $conn->begin_transaction();

    try {
        // 1. Dapatkan stok sparepart saat ini dan harga eceran
        $stmt_get_stok = $conn->prepare('SELECT stok, nama, harga_eceran FROM sparepart WHERE id = ?');
        $stmt_get_stok->bind_param('i', $sparepart_id);
        $stmt_get_stok->execute();
        $result_stok = $stmt_get_stok->get_result();
        if ($result_stok->num_rows === 0) {
            throw new Exception('Sparepart dengan ID ' . $sparepart_id . ' tidak ditemukan.');
        }
        $sparepart_data = $result_stok->fetch_assoc();
        $stok_saat_ini = $sparepart_data['stok'];
        $sparepart_nama = $sparepart_data['nama'];
        $harga_eceran_item = $sparepart_data['harga_eceran'];
        $stmt_get_stok->close();

        // 2. Update stok berdasarkan jenis transaksi
        $new_stok = $stok_saat_ini;
        if ($jenis === 'keluar') {
            if ($stok_saat_ini < $jumlah) {
                throw new Exception('Stok tidak cukup untuk sparepart ' . $sparepart_nama . '. Stok tersedia: ' . $stok_saat_ini);
            }
            $new_stok -= $jumlah;
        } elseif ($jenis === 'masuk') {
            $new_stok += $jumlah;
        }

        $stmt_update_stok = $conn->prepare('UPDATE sparepart SET stok = ? WHERE id = ?');
        $stmt_update_stok->bind_param('ii', $new_stok, $sparepart_id);
        $stmt_update_stok->execute();
        if ($stmt_update_stok->affected_rows === 0) {
            // Ini bisa terjadi jika stok tidak berubah, tapi tetap sukses jika tidak ada error lain
            // atau jika ID sparepart tidak valid (tapi sudah dicek di atas)
            // throw new Exception('Gagal memperbarui stok sparepart.'); // Bisa diaktifkan jika perlu strict
        }
        $stmt_update_stok->close();

        // 3. Masukkan data transaksi ke tabel 'transaksi'
        // PERHATIKAN: Saya menambahkan 'employee_name' ke dalam daftar kolom
        $stmt_transaksi = $conn->prepare('INSERT INTO transaksi (sparepart_id, jenis, jumlah, ppn, keterangan, employee_name) VALUES (?, ?, ?, ?, ?, ?)');
        // PERHATIKAN: Saya menambahkan 's' untuk string parameter employee_name
        $stmt_transaksi->bind_param('isidss', $sparepart_id, $jenis, $jumlah, $ppn, $keterangan, $loggedInEmployeeName);
        $stmt_transaksi->execute();
        $transaksi_id = $conn->insert_id; // Dapatkan ID transaksi yang baru dibuat
        $stmt_transaksi->close();

        // Commit transaksi jika semua berhasil
        $conn->commit();

        // --- TAMBAHAN UNTUK STRUK ---
        // PPN rate yang digunakan di frontend adalah 0.11
        $ppn_rate_frontend = 0.11; // Sesuaikan jika PPN_ITEM dari frontend adalah nominal PPN bukan rate

        $item_detail_for_receipt = [
            'transaksi_id' => $transaksi_id,
            'sparepart_id' => $sparepart_id,
            'sparepart_nama' => $sparepart_nama,
            'harga_satuan' => $harga_eceran_item, // Harga satuan dari database
            'jenis' => $jenis,
            'jumlah' => $jumlah,
            'ppn_rate' => $ppn_rate_frontend, // PPN rate yang digunakan untuk perhitungan
            'keterangan' => $keterangan,
            'subtotal_item' => $jumlah * $harga_eceran_item,
            'ppn_nominal_item' => ($jumlah * $harga_eceran_item) * $ppn_rate_frontend, // Hitung PPN nominal untuk item ini
            'employee_name' => $loggedInEmployeeName // Tambahkan nama karyawan ke detail struk
        ];
        // --- AKHIR TAMBAHAN ---

        respond('success', 'Transaksi berhasil disimpan', ['transaksi_id' => $transaksi_id, 'stok_baru' => $new_stok, 'item_receipt_detail' => $item_detail_for_receipt]);

    } catch (Exception $e) {
        // Rollback jika ada kesalahan
        $conn->rollback();
        error_log('Transaksi gagal: ' . $e->getMessage());
        respond('error', 'Transaksi gagal: ' . $e->getMessage());
    }

} else {
    // Jika metode selain POST digunakan, respon dengan error
    http_response_code(405); // Method Not Allowed
    respond('error', 'Metode tidak diizinkan');
}

$conn->close();
?>