<?php
// Aktifkan logging error (nonaktifkan tampilan di produksi)
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/error.log');

// Set header untuk API
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, DELETE, PUT, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

// Tangani CORS preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Koneksi database
$host = 'localhost';
$user = 'rhlqyjgg_admin';
$pass = 'xub!.&%O1pOU';
$db   = 'rhlqyjgg_dbbengkel';

$conn = new mysqli($host, $user, $pass, $db);
$conn->set_charset('utf8mb4');
if ($conn->connect_error) {
    http_response_code(500);
    error_log('Koneksi database gagal: ' . $conn->connect_error);
    echo json_encode(['status' => 'error', 'message' => 'Koneksi database gagal']);
    exit;
}

// Konfigurasi
$baseUrl = 'https://api-bengkel.sumberbarokahsentosa.my.id/';
$uploadDir = __DIR__ . '/Uploads/'; // Tidak terlalu dibutuhkan untuk DELETE, tapi dipertahankan untuk konsistensi

function respond($status, $message, $extra = []) {
    echo json_encode(array_merge(['status' => $status, 'message' => $message], $extra));
    exit;
}

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'DELETE') {
    // Untuk request DELETE, input biasanya datang dari php://input
    $input = json_decode(file_get_contents('php://input'), true);
    $id = intval($input['id'] ?? 0);

    if ($id <= 0) {
        respond('error', 'ID sparepart tidak valid');
    }

    // Periksa apakah sparepart ada sebelum mencoba menghapus
    $stmt = $conn->prepare('SELECT foto FROM sparepart WHERE id = ?');
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows === 0) {
        respond('error', 'Sparepart dengan ID tersebut tidak ditemukan');
    }
    $row = $result->fetch_assoc();
    $fotoPath = $row['foto'];
    $stmt->close();

    // Hapus sparepart dari database
    $stmt = $conn->prepare('DELETE FROM sparepart WHERE id = ?');
    $stmt->bind_param('i', $id);

    if ($stmt->execute()) {
        // Jika sparepart berhasil dihapus, hapus juga file fotonya
        if ($fotoPath && file_exists($fotoPath) && !is_dir($fotoPath)) {
            if (unlink($fotoPath)) {
                respond('success', 'Sparepart dan foto berhasil dihapus');
            } else {
                // Catat error tetapi tetap laporkan sukses untuk penghapusan database
                error_log('Gagal menghapus file foto: ' . $fotoPath);
                respond('success', 'Sparepart berhasil dihapus, tetapi gagal menghapus foto');
            }
        } else {
            respond('success', 'Sparepart berhasil dihapus');
        }
    } else {
        respond('error', 'Gagal menghapus sparepart: ' . $stmt->error);
    }
    $stmt->close();
} else {
    // Jika metode selain DELETE digunakan, respon dengan error
    http_response_code(405); // Metode Tidak Diizinkan
    respond('error', 'Metode tidak diizinkan');
}

$conn->close();
?>