<?php
// Aktifkan logging error (nonaktifkan tampilan di production)
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/error.log');

// Atur header untuk API
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: DELETE, OPTIONS'); // Izinkan metode DELETE dan OPTIONS
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

// Handle preflight request dari browser
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Koneksi Database (sama seperti skrip create)
$host = 'localhost';
$user = 'rhlqyjgg_admin';
$pass = 'xub!.&%O1pOU';
$db   = 'rhlqyjgg_dbbengkel';

$conn = new mysqli($host, $user, $pass, $db);
$conn->set_charset('utf8mb4');
if ($conn->connect_error) {
    http_response_code(500);
    error_log('Database connection failed: ' . $conn->connect_error);
    echo json_encode(['status' => 'error', 'message' => 'Koneksi database gagal']);
    exit;
}

// Fungsi helper untuk mengirim response JSON
function respond($status, $message, $extra = []) {
    echo json_encode(array_merge(['status' => $status, 'message' => $message], $extra));
    exit;
}

// Pastikan metode yang digunakan adalah DELETE
if ($_SERVER['REQUEST_METHOD'] !== 'DELETE') {
    http_response_code(405); // Method Not Allowed
    respond('error', 'Metode tidak diizinkan. Harap gunakan metode DELETE.');
}

// Ambil data JSON dari body request
$input = json_decode(file_get_contents('php://input'), true);
$transaksi_id = intval($input['id'] ?? 0);

// Validasi ID transaksi
if ($transaksi_id <= 0) {
    respond('error', 'ID transaksi tidak valid.');
}

// Mulai transaksi database untuk memastikan semua operasi berhasil atau gagal bersamaan
$conn->begin_transaction();

try {
    // 1. Ambil detail transaksi yang akan dihapus (jenis dan jumlahnya)
    $stmt_get_trans = $conn->prepare('SELECT sparepart_id, jenis, jumlah FROM transaksi WHERE id = ?');
    $stmt_get_trans->bind_param('i', $transaksi_id);
    $stmt_get_trans->execute();
    $result_trans = $stmt_get_trans->get_result();
    
    if ($result_trans->num_rows === 0) {
        throw new Exception('Transaksi dengan ID ' . $transaksi_id . ' tidak ditemukan.');
    }
    
    $transaksi_data = $result_trans->fetch_assoc();
    $sparepart_id = $transaksi_data['sparepart_id'];
    $jenis_transaksi = $transaksi_data['jenis'];
    $jumlah_transaksi = $transaksi_data['jumlah'];
    $stmt_get_trans->close();

    // 2. Kembalikan stok sparepart
    $stok_sekarang = 0;
    $stmt_get_stok = $conn->prepare('SELECT stok FROM sparepart WHERE id = ?');
    $stmt_get_stok->bind_param('i', $sparepart_id);
    $stmt_get_stok->execute();
    $result_stok = $stmt_get_stok->get_result();
    if($result_stok->num_rows > 0) {
        $stok_sekarang = $result_stok->fetch_assoc()['stok'];
    }
    $stmt_get_stok->close();

    // Logika pembalikan stok:
    // - Jika transaksi 'keluar' dihapus, stok ditambah kembali.
    // - Jika transaksi 'masuk' dihapus, stok dikurangi.
    if ($jenis_transaksi === 'keluar') {
        $stok_baru = $stok_sekarang + $jumlah_transaksi;
    } else { // jenis_transaksi === 'masuk'
        $stok_baru = $stok_sekarang - $jumlah_transaksi;
        // Tambahkan pengaman agar stok tidak menjadi negatif
        if ($stok_baru < 0) {
            throw new Exception('Gagal menghapus transaksi masuk karena akan menyebabkan stok menjadi negatif.');
        }
    }

    $stmt_update_stok = $conn->prepare('UPDATE sparepart SET stok = ? WHERE id = ?');
    $stmt_update_stok->bind_param('ii', $stok_baru, $sparepart_id);
    $stmt_update_stok->execute();
    $stmt_update_stok->close();

    // 3. Hapus catatan dari tabel 'transaksi'
    $stmt_delete = $conn->prepare('DELETE FROM transaksi WHERE id = ?');
    $stmt_delete->bind_param('i', $transaksi_id);
    $stmt_delete->execute();
    
    // Periksa apakah ada baris yang terhapus
    if ($stmt_delete->affected_rows === 0) {
        // Ini seharusnya tidak terjadi jika pengecekan pertama berhasil, tapi sebagai pengaman
        throw new Exception('Gagal menghapus catatan transaksi dari database.');
    }
    $stmt_delete->close();

    // Jika semua langkah berhasil, commit transaksi
    $conn->commit();
    
    respond('success', 'Transaksi berhasil dihapus dan stok telah dikembalikan.');

} catch (Exception $e) {
    // Jika terjadi kesalahan di salah satu langkah, batalkan semua perubahan (rollback)
    $conn->rollback();
    error_log('Penghapusan transaksi gagal: ' . $e->getMessage());
    respond('error', 'Gagal menghapus transaksi: ' . $e->getMessage());
}

$conn->close();
?>