<?php
// Set header CORS
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

// Set header default ke JSON
header('Content-Type: application/json');

// Sertakan file koneksi database Anda
include "koneksi.php";

// Ambil data JSON dari request body
$input = json_decode(file_get_contents("php://input"), true);

// --- Validasi Input ---
// Pastikan username dan password ada
if (!isset($input['username'], $input['password'])) {
    http_response_code(400); // Bad Request
    echo json_encode([
        "success" => false,
        "message" => "Username dan password wajib diisi."
    ]);
    exit;
}

$username = mysqli_real_escape_string($conn, $input['username']);
$password = $input['password']; // Password akan di-hash, tidak perlu di-escape di sini

// Tentukan role: Jika tidak dikirim, set default ke 'karyawan'.
// Pastikan hanya satu nilai default yang diberikan jika 'role' tidak ada.
$role = isset($input['role']) ? mysqli_real_escape_string($conn, $input['role']) : 'karyawan'; // Default 'karyawan'

// Daftar role yang diizinkan
$allowed_roles = ['admin', 'pelanggan', 'karyawan'];

// Validasi role harus salah satu dari yang diizinkan
if (!in_array($role, $allowed_roles)) {
    http_response_code(400); // Bad Request
    echo json_encode([
        "success" => false,
        "message" => "Role tidak valid. Pilihan role: admin, pelanggan, karyawan."
    ]);
    exit;
}

// --- Cek Duplikasi Username ---
$sql_check = "SELECT id FROM user WHERE username = '$username' LIMIT 1";
$result_check = mysqli_query($conn, $sql_check);

if (!$result_check) {
    // Tangani kesalahan kueri SQL untuk pemeriksaan username
    http_response_code(500); // Internal Server Error
    echo json_encode([
        "success" => false,
        "message" => "Terjadi kesalahan server saat memeriksa username."
    ]);
    mysqli_close($conn);
    exit;
}

if (mysqli_num_rows($result_check) > 0) {
    http_response_code(409); // Conflict
    echo json_encode([
        "success" => false,
        "message" => "Username sudah digunakan."
    ]);
    mysqli_close($conn);
    exit;
} else {
    // --- Enkripsi Password ---
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);

    // --- Simpan ke Database ---
    // Pastikan nama kolom 'password' dan 'role' sesuai di tabel 'user' Anda.
    $sql_insert = "INSERT INTO user (username, password, role) VALUES ('$username', '$hashed_password', '$role')";

    if (mysqli_query($conn, $sql_insert)) {
        $new_user_id = mysqli_insert_id($conn); // Dapatkan ID pengguna yang baru dibuat

        http_response_code(201); // Created
        echo json_encode([
            "success" => true,
            "message" => "Registrasi berhasil!",
            "data" => [
                "user_id" => $new_user_id,
                "username" => $username,
                "role" => $role
            ]
        ]);
    } else {
        // Kesalahan saat menyimpan ke database
        http_response_code(500); // Internal Server Error
        echo json_encode([
            "success" => false,
            "message" => "Terjadi kesalahan saat registrasi: " . mysqli_error($conn) // Untuk debugging, hapus ini di produksi
        ]);
    }
}

// Tutup koneksi database
mysqli_close($conn);
?>