<?php
// Enable error logging (disable display in production)
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/error.log');

// Set headers for API
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, DELETE, PUT, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

// Handle CORS preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Database connection
$host = 'localhost';
$user = 'rhlqyjgg_admin';
$pass = 'xub!.&%O1pOU';
$db   = 'rhlqyjgg_dbbengkel';

$conn = new mysqli($host, $user, $pass, $db);
$conn->set_charset('utf8mb4');
if ($conn->connect_error) {
    http_response_code(500);
    error_log('Database connection failed: ' . $conn->connect_error);
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
    exit;
}

function respond($status, $message, $extra = []) {
    echo json_encode(array_merge(['status' => $status, 'message' => $message], $extra));
    exit;
}

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'PUT') {
    // Untuk request PUT, input datang dari php://input sebagai JSON
    $input = json_decode(file_get_contents('php://input'), true);

    $id = intval($input['id'] ?? 0);
    $stok = intval($input['stok'] ?? -1); // Gunakan nilai default yang tidak valid untuk validasi
    $harga_grosir = floatval($input['harga_grosir'] ?? -1.0);
    $harga_eceran = floatval($input['harga_eceran'] ?? -1.0);

    // Validasi input
    if ($id <= 0) {
        respond('error', 'ID sparepart tidak valid');
    }
    if ($stok < 0) {
        respond('error', 'Stok tidak boleh negatif');
    }
    if ($harga_grosir < 0) {
        respond('error', 'Harga grosir tidak boleh negatif');
    }
    if ($harga_eceran < 0) {
        respond('error', 'Harga eceran tidak boleh negatif');
    }

    // Periksa apakah sparepart dengan ID tersebut ada
    $stmt = $conn->prepare('SELECT id FROM sparepart WHERE id = ?');
    $stmt->bind_param('i', $id);
    $stmt->execute();
    if ($stmt->get_result()->num_rows === 0) {
        respond('error', 'Sparepart dengan ID tersebut tidak ditemukan');
    }
    $stmt->close();

    // Lakukan update data
    $stmt = $conn->prepare('UPDATE sparepart SET stok = ?, harga_grosir = ?, harga_eceran = ? WHERE id = ?');
    $stmt->bind_param('iddi', $stok, $harga_grosir, $harga_eceran, $id);

    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            respond('success', 'Sparepart berhasil diupdate');
        } else {
            respond('success', 'Tidak ada perubahan pada sparepart (data yang dikirim sama)');
        }
    } else {
        respond('error', 'Gagal mengupdate sparepart: ' . $stmt->error);
    }
    $stmt->close();
} else {
    // Jika metode selain PUT digunakan, respon dengan error
    http_response_code(405); // Method Not Allowed
    respond('error', 'Metode tidak diizinkan');
}

$conn->close();
?>